unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ExtCtrls, StdCtrls;

type
  TForm1 = class(TForm)
    OpenDialog1: TOpenDialog;
    Button1: TButton;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
    isFullScreen : Boolean;
    OldRect : TRect;
    OldStyle : Longint;
    procedure WndProc(var Message : TMessage); override;
  end;

var
  Form1: TForm1;

implementation

uses Bass, BassVideo, Unit2;

{$R *.dfm}
var chan1 : DWORD;

function myVideoProc(Handle : DWORD; Action, param1, param2 : DWORD; user : Pointer) : BOOL; stdcall;
var R : TRect;
begin
 case Action of
  BassVideo_FoundVideo :
    begin
      if chan1 = 0 then
       begin
        R := Form1.ClientRect;
        R.Left := 0;
        R.Top := 0;
        BASSVideo_SetVideoWindow(Handle, Form1.Handle, R, 0);
      end;
      end;
    end;
  result := FALSE;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
 Bass_Init(-1, 44100, 0, 0, nil);
 BassVideo_Init();
 BassVideo_SetConfig(BassVideo.BassVideo_Config_Renderer, BassVideo.BassVideo_VMR9);
end;

procedure TForm1.FormDestroy(Sender: TObject);
begin
 if chan1 <> 0 then
  begin
   BassVideo_Stop(chan1);
   BassVideo_StreamFree(chan1);
  end;
 BassVideo_Free();
 Bass_Free;
end;

procedure TForm1.Button1Click(Sender: TObject);
var s : string;
    R : TRect;
begin
 if OpenDialog1.Execute then
  begin
    s := OpenDialog1.FileName;
    chan1 := BassVideo.BassVideo_StreamCreateFile(PChar(s),  BASSVIDEO_AUTO_PAINT or BASSVIDEO_AUTO_RESIZE or BASSVIDEO_AUTO_MOVE
                                                  , 0, @myVideoProc, nil);
    R := Form2.ClientRect;
    BassVideo.BassVideo_AddVideo(chan1, Form2.Handle, R, 0);
    if BassVideo_Play(chan1) then
     Caption := 'OK';
    Button1.Hide;
  end
 else Application.Terminate;
end;

procedure TForm1.WndProc(var Message: TMessage);
var R : TRect;
begin
  inherited;
  case Message.Msg of
   WM_MOVE  : begin
                BassVideo_WindowMove(chan1, Message.Msg, Message.WParam, Message.LParam, 0);
              end;
   WM_SIZE  : begin
                R := Form1.ClientRect;
                R.Left := 0; R.Top := 0;
                BassVideo_WindowResize(chan1, R, 0);
              end;
  end;
end;

end.
